package editor;

import java.awt.Color;
import java.util.ArrayList;

public class MovingBlockLoadData {
	
	private int width;
	private int height;
	private int defaultSpeed;
	private Boolean isPassThru;
	private String image;
	private Color transparentColor;
	private boolean isVertical;
	private char dir;
	private ArrayList<MovingBlockPointData> spawnPoints;
	
	public MovingBlockLoadData(boolean shouldBeVertical) {
		isVertical = shouldBeVertical;
		spawnPoints = new ArrayList<MovingBlockPointData>();
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public int getDefaultSpeed() {
		return defaultSpeed;
	}

	public void setDefaultSpeed(int defaultSpeed) {
		this.defaultSpeed = defaultSpeed;
	}

	public Boolean getIsPassThru() {
		return isPassThru;
	}

	public void setIsPassThru(Boolean isPassThru) {
		this.isPassThru = isPassThru;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public Color getTransparentColor() {
		return transparentColor;
	}

	public void setTransparentColor(Color transparentColor) {
		this.transparentColor = transparentColor;
	}

	public boolean isVertical() {
		return isVertical;
	}

	public void setVertical(boolean isVertical) {
		this.isVertical = isVertical;
	}

	public char getDir() {
		return dir;
	}

	public void setDir(char dir) {
		this.dir = dir;
	}

	public ArrayList<MovingBlockPointData> getSpawnPoints() {
		return spawnPoints;
	}
	
	public void addSpawnPoint(MovingBlockPointData p) {
		int spawnPointsSize = spawnPoints.size();
		
		for(int i = 0; i < spawnPoints.size(); i++) {
			if(spawnPoints.get(i).depth > p.depth) {
				spawnPoints.add(i, p);
				i = spawnPoints.size();
			}
		}
		
		if(spawnPointsSize == spawnPoints.size()) {
			spawnPoints.add(p);
		}
	}
	
}
